/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips.data.tip;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.darkhax.bookshelf.serialization.Serializers;
import net.darkhax.tips.TipsAPI;
import net.darkhax.tips.data.tip.ITip;
import net.darkhax.tips.data.tip.ITipSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class SimpleTip
implements ITip {
    public static final ResourceLocation TYPE_ID = new ResourceLocation("tips", "simple_tip");
    public static final ITipSerializer<?> SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final ITextComponent title;
    private final ITextComponent text;

    public SimpleTip(ResourceLocation id, ITextComponent title, ITextComponent text) {
        this.id = id;
        this.title = title;
        this.text = text;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ITextComponent getTitle() {
        return this.title;
    }

    @Override
    public ITextComponent getText() {
        return this.text;
    }

    static final class Serializer
    implements ITipSerializer<SimpleTip> {
        Serializer() {
        }

        @Override
        public SimpleTip read(ResourceLocation id, JsonObject json) {
            ITextComponent title = (ITextComponent)Serializers.TEXT.read(json, "title", (Object)TipsAPI.DEFAULT_TITLE);
            ITextComponent text = (ITextComponent)Serializers.TEXT.read(json, "tip");
            return new SimpleTip(id, title, text);
        }

        @Override
        public JsonElement write(SimpleTip toWrite) {
            JsonObject json = new JsonObject();
            json.add("type", Serializers.RESOURCE_LOCATION.write((Object)TYPE_ID));
            json.add("title", Serializers.TEXT.write((Object)toWrite.title));
            json.add("tip", Serializers.TEXT.write((Object)toWrite.text));
            return json;
        }
    }
}

